k6 v0.28.0 is here! :tada: It's a small release that adds some much requested features and a few important bugfixes!

Starting with this release, we'll be trying to stick to a new 8-week fixed release schedule for new k6 versions. This release comes ~8 weeks after v0.27.0 was released, and k6 v0.29.0 should be released in mid-November.

## New features and enhancements!

### Cloud execution logs ([#1599](https://github.com/loadimpact/k6/pull/1599))

Logs from distributed k6 cloud test runs will now be shown in the terminal that executed the `k6 cloud` command, as well as in the k6 cloud web app on [app.k6.io](https://app.k6.io/)! :tada: This means that, if your script contains `console.log()` / `console.warn()` / etc. calls, or some of your requests or iterations fail, you'd be able to see that and debug them much more easily! Even `--http-debug` data should be proxied, up to 10000 bytes per message. To prevent abuse and not to overwhelm any user terminals, cloud logs are rate-limited at 10 messages per second per instance, for now, but that should be more than enough to debug most issues!

This feature is enabled by default, though you can disable it with `k6 cloud --show-logs=false script.js`.


### Pushing k6 logs to loki ([#1576](https://github.com/loadimpact/k6/pull/1576))

k6 can now push its execution logs to a loki server! This can be done via the new `--log-output` CLI flag or the `K6_LOG_OUTPUT` environment variable option. For example, `k6 run --log-output "loki=https://my-loki-server/loki/api/v1/push,limit=100,level=info,msgMaxSize=10000"` will push up to 100 k6 log messages per second, of severity `INFO` and up, truncated to `10000` bytes, to `https://my-loki-server`.

### Optional port to host mappings ([#1489](https://github.com/loadimpact/k6/pull/1489))

@calavera added an extension for the host mapping feature. Now you can specify different port numbers via the [`hosts` option](https://k6.io/docs/using-k6/options#hosts), like this:

```js
import http from 'k6/http';

export let options = {
    hosts: {
        'test.k6.io': '127.0.0.1:8080',
    },
};
```

### Support for specifying data types to InfluxDB fields ([#1395](https://github.com/loadimpact/k6/pull/1395))

@TamiTakamiya added support for specifying the data type (int/float/bool/string) of fields that are emitted to InfluxDB outputs.

In order to specify the data type, you should:
- Use the environment variable `K6_INFLUXDB_TAGS_AS_FIELDS`, which is used to specify which k6 metric tag values should be sent as nonindexable fields (instead of tags) to an InfluxDB output. This is specified as a comma-separated string, and is now extended to optionally allow specifying a data type to each name.
- Each pair of field name and its data type is represented in the format `(name):(data_type)`, for example, `event_processing_time:int`.
- One of four data types (`int`, `float`, `bool` and `string`) can be specified to one field name.
- When the colon and a `data_type` are omitted, for example `transaction_id`, it is interpreted as a string field.

A complete example can look like this: `export K6_INFLUXDB_TAGS_AS_FIELDS="vu:int,iter:int,url:string,boolField:bool,floatField:float"`

_Note: If you have existing InfluxDB databases that contain fields whose data types are different from the ones that you want to save in future k6 test executions, you may want to create a new database or change field names as the current InfluxDB offers limited support for changing fields' data type. See the [InfluxDB documentation](https://docs.influxdata.com/influxdb/v1.8/troubleshooting/frequently-asked-questions/#can-i-change-a-field-s-data-type) for more details._

### Support for automatic gzip-ing of the CSV output result ([#1566](https://github.com/loadimpact/k6/pull/1566))

@thejasbabu added support to gzip archiving the file emitted by the CSV output on the fly. To use it, simply append `.gz` at the end of the file name, like this: `k6 run --out csv=test.csv.gz test.js`

## UX

- Various spacing and progress bar rendering issues were improved ([#1580](https://github.com/loadimpact/k6/issues/1580)).
- The k6 ASCII logo was made a bit more proportional ([#1615](https://github.com/loadimpact/k6/pull/1615/commits/54a3168f0945fa8243edb7540fe78ad7ac66a8dc)). Thanks, @rawtaz!
- The docker-compose example setup from the k6 repo now contains a built-in simple dashboard ([#1610](https://github.com/loadimpact/k6/pull/1610)). Thanks, @jeevananthank!
- Some logs now have a `source` field specifying if a log comes from `console`, `http-debug` or `stacktrace` (when an exception has bubbled to the top of the iteration).

## Bugs fixed!

- Network: IPv6 support was fixed as a part of the new `hosts` port mapping ([#1489](https://github.com/loadimpact/k6/pull/1489)). Thanks, @calavera!
- Metrics: Fixed the wrong `name` metric tag for redirected requests ([#1474](https://github.com/loadimpact/k6/issues/1474)).
- UI: Fixed a `divide by zero` panic caused by some unusual execution environments that present a TTY, but return `0` for the terminal size ([#1581](https://github.com/loadimpact/k6/pull/1581)).
- Config: Fixed the parsing of `K6_DATADOG_TAG_BLACKLIST` ([#1602](https://github.com/loadimpact/k6/issues/1602)).
- Config: Fixed marshaling of `tlsCipherSuites` and `tlsVersion` ([#1603](https://github.com/loadimpact/k6/pull/1603)). Thanks, @berndhartzer!
- WebSockets: Fixed a `ws.SetTimeout()` and `ws.SetInterval()` panic when float values were passed ([#1608](https://github.com/loadimpact/k6/pull/1608)).

## Internals

- goja, the JavaScript runtime k6 uses, was updated to the latest version. This means that k6 with `--compatibility-mode=base` now supports some standard library features from ES6 ([goja's PR](https://github.com/dop251/goja/pull/180)), though no new syntax yet. In future versions we plan to drop some current core.js modules that are no longer needed, which should greatly reduce memory usage per VU ([#1588](https://github.com/loadimpact/k6/pull/1588)).
- Go modules are now used to manage the k6 dependencies instead of `dep` ([#1584](https://github.com/loadimpact/k6/pull/1584)).

## Breaking changes

- `k6 cloud` will now proxy execution logs back to the client machine. To disable this behavior, use `k6 cloud --show-logs=false`.

- `--http-debug` request and response dumps are now emitted through the logging sub-system, to facilitate the cloud log proxying ([#1577](https://github.com/loadimpact/k6/pull/1577)).
